

#ifndef __QHYCCDCAMDEF_H__
#define __QHYCCDCAMDEF_H__



/* IMG series */

/**
 * Type define for IMG0S */
#define DEVICETYPE_IMG0S        1000

/**
 * Type define for IMG0H */
#define DEVICETYPE_IMG0H        1001

/**
 * Type define for IMG0L */
#define DEVICETYPE_IMG0L        1002

/**
 * Type define for IMG0X */
#define DEVICETYPE_IMG0X        1003

/**
 * Type define for IMG1S */
#define DEVICETYPE_IMG1S        1004

/**
 * Type define for IMG2S */
#define DEVICETYPE_IMG2S        1005

/**
 * Type define for IMG1E */
#define DEVICETYPE_IMG1E        1006


/* QHY5 seires */

/**
 * Type define for QHY5 */
#define DEVICETYPE_QHY5         2001


/* QHY5II series */

/**
 * Type define for QHY5II */
#define DEVICETYPE_QHY5II       3001

/**
 * Type define for QHY5LII_M */
#define DEVICETYPE_QHY5LII_M    3002

/**
 * Type define for QHY5LII_C */
#define DEVICETYPE_QHY5LII_C    3003

/**
 * Type define for QHY5TII */
#define DEVICETYPE_QHY5TII      3004

/**
 * Type define for QHY5RII */
#define DEVICETYPE_QHY5RII      3005

/**
 * Type define for QHY5PII */
#define DEVICETYPE_QHY5PII      3006

/**
 * Type define for QHY5VII */
#define DEVICETYPE_QHY5VII      3007

/**
 * Type define for QHY5HII */
#define DEVICETYPE_QHY5HII      3008

/**
 * Type define for QHYXXX */
#define DEVICETYPE_MINICAM5S_M  3009

/**
 * Type define for QHYXXX */
#define DEVICETYPE_MINICAM5S_C  3010

/**
 * Type define for QHY5PII_C */
#define DEVICETYPE_QHY5PII_C    3011

/**
 * Type define for QHY5RII-C */
#define DEVICETYPE_QHY5RII_C    3012

/**
 * Type define for QHY5RII-M */
#define DEVICETYPE_MINICAM5F_M  3013

/**
 * Type define for QHY5PII_M */
#define DEVICETYPE_QHY5PII_M    3014

/**
 * Type define for QHY5TII */
#define DEVICETYPE_QHY5TII_C    3015

/**
 * Type define for POLEMASTER */
#define DEVICETYPE_POLEMASTER   3016

/**
 * Type define for QHY5IIEND */
#define DEVICETYPE_QHY5IIEND   3999


/* QHY5III seires */

/**
 * Type define for QHY5III174*/
#define DEVICETYPE_QHY5III174   4000

/**
 * Type define for QHY5III174 */
#define DEVICETYPE_QHY5III174M  4001

/**
 * Type define for QHY5III174C*/
#define DEVICETYPE_QHY5III174C  4002

/**
 * Type define for QHY174*/
#define DEVICETYPE_QHY174       4003

/**
 * Type define for QHY174M*/
#define DEVICETYPE_QHY174M      4004

/**
 * Type define for QHY174C*/
#define DEVICETYPE_QHY174C      4005

/**
 * Type define for QHY5III178*/
#define DEVICETYPE_QHY5III178   4006

/**
 * Type define for QHY5III178C*/
#define DEVICETYPE_QHY5III178C  4007

/**
 * Type define for QHY5III178M*/
#define DEVICETYPE_QHY5III178M  4008

/**
 * Type define for QHY178*/
#define DEVICETYPE_QHY178       4009

/**
 * Type define for QHY178M*/
#define DEVICETYPE_QHY178M      4010

/**
 * Type define for QHY178C*/
#define DEVICETYPE_QHY178C      4011

/**
 * Type define for QHY5III185*/
#define DEVICETYPE_QHY5III185   4012

/**
 * Type define for QHY5III185C*/
#define DEVICETYPE_QHY5III185C  4013

/**
 * Type define for QHY5III185M*/
#define DEVICETYPE_QHY5III185M  4014

/**
 * Type define for QHY185*/
#define DEVICETYPE_QHY185       4015

/**
 * Type define for QHY185M*/
#define DEVICETYPE_QHY185M      4016

/**
 * Type define for QHY185C*/
#define DEVICETYPE_QHY185C      4017

/**
 * Type define for QHY5III224*/
#define DEVICETYPE_QHY5III224   4018

/**
 * Type define for QHY5III224C*/
#define DEVICETYPE_QHY5III224C  4019

/**
 * Type define for QHY5III224M*/
#define DEVICETYPE_QHY5III224M  4020

/**
 * Type define for QHY224*/
#define DEVICETYPE_QHY224       4021

/**
 * Type define for QHY224M*/
#define DEVICETYPE_QHY224M      4022

/**
 * Type define for QHY224C*/
#define DEVICETYPE_QHY224C      4023

/**
 * Type define for QHY5III290*/
#define DEVICETYPE_QHY5III290    4024

/**
 * Type define for QHY5III290C*/
#define DEVICETYPE_QHY5III290C  4025

/**
 * Type define for QHY5III290M*/
#define DEVICETYPE_QHY5III290M  4026

/**
 * Type define for QHY290*/
#define DEVICETYPE_QHY290       4027

/**
 * Type define for QHY290M*/
#define DEVICETYPE_QHY290M      4028

/**
 * Type define for QHY290C*/
#define DEVICETYPE_QHY290C      4029

/**
 * Type define for QHY5III236*/
#define DEVICETYPE_QHY5III236   4030

/**
 * Type define for QHY5III236C*/
#define DEVICETYPE_QHY5III236C  4031

/**
 * Type define for QHY5III290M*/
#define DEVICETYPE_QHY5III236M  4032

/**
 * Type define for QHY236*/
#define DEVICETYPE_QHY236       4033

/**
 * Type define for QHY236M*/
#define DEVICETYPE_QHY236M      4034

/**
 * Type define for QHY236C*/
#define DEVICETYPE_QHY236C      4035

/**
 * Type define for GSENSE400*/
#define DEVICETYPE_QHY5IIIG400M 4036

/**
 * Type define for QHY163*/
#define DEVICETYPE_QHY163       4037

/**
 * Type define for QHY163M*/
#define DEVICETYPE_QHY163M      4038

/**
 * Type define for QHY163C*/
#define DEVICETYPE_QHY163C      4039

/**
 * Type define for QHY165*/
#define DEVICETYPE_QHY165       4040

/**
 * Type define for QHY165C*/
#define DEVICETYPE_QHY165C      4041

/**
 * Type define for QHY367*/
#define DEVICETYPE_QHY367       4042

/**
 * Type define for QHY367C*/
#define DEVICETYPE_QHY367C      4043

/**
 * Type define for QHY183*/
#define DEVICETYPE_QHY183       4044

/**
 * Type define for QHY183C*/
#define DEVICETYPE_QHY183C      4045

/**
 * Type define for QHY-DevelopDev*/
#define DEVICETYPE_QHY5IIICOMMON 4046

/**
 * Type define for QHY247*/
#define DEVICETYPE_QHY247       4047

/**
 * Type define for QHY247C*/
#define DEVICETYPE_QHY247C      4048

/**
 * Type define for MINICAM6F*/
#define DEVICETYPE_MINICAM6F    4049

/**
 * Type define for QHY168C*/
#define DEVICETYPE_QHY168       4050

#define DEVICETYPE_QHY168C      4051

/**
 * Type define for QHY128C*/
#define DEVICETYPE_QHY128        4052

#define DEVICETYPE_QHY128C      4053
#define DEVICETYPE_QHY294        4054
#define DEVICETYPE_QHY2020      4055
#define DEVICETYPE_QHY4040      4056
#define DEVICETYPE_QHY550        4057
#define DEVICETYPE_QHY42PRO   4058
#define DEVICETYPE_QHY6060      4059
#define DEVICETYPE_QHY411        4060

#define DEVICETYPE_QHY600        	4061
#define DEVICETYPE_QHY600C      	4062
#define DEVICETYPE_QHY600M     		4063
#define DEVICETYPE_QHY0204      	4064

#define DEVICETYPE_QHY411ERIS  		4065
#define DEVICETYPE_QHY411MERIS  	4066
#define DEVICETYPE_QHY411CERIS  	4067

#define DEVICETYPE_QHY367PROC  		4068

#define DEVICETYPE_QHY268C      	4069
#define DEVICETYPE_QHY410C      	4070
#define DEVICETYPE_QHY432        	4071
#define DEVICETYPE_QHY342        	4072
#define DEVICETYPE_QHY4040PRO 		4073
#define DEVICETYPE_QHY128PROC       4074

#define DEVICETYPE_QHY5III462       4075
#define DEVICETYPE_QHY5III462C      4076
#define DEVICETYPE_QHY5III462M      4077

#define DEVICETYPE_QHY533C      	4078
#define DEVICETYPE_QHY492M      	4079

#define DEVICETYPE_QHY461     	    4080
#define DEVICETYPE_QHY461M     	    4081
#define DEVICETYPE_QHY461C     	    4082

#define DEVICETYPE_QHY492MT      	4083
#define DEVICETYPE_QHY5III485       4084
#define DEVICETYPE_QHY294PRO        4085
#define DEVICETYPE_QHY294MPRO        4086
#define DEVICETYPE_QHY294CPRO        4087

#define DEVICETYPE_QHY4040PRO_F 	4088
#define DEVICETYPE_QHY4040PRO_B 	4089
#define DEVICETYPE_QHY268M      	4090
#define DEVICETYPE_QHY4040PRO_FN 	4091
#define DEVICETYPE_QHY4040PRO_BN 	4092

#define DEVICETYPE_QHY990        	4093


/**
 * Type define for QHY5III178C*/
#define DEVICETYPE_QHY5III178C_Celestron      4094

#define DEVICETYPE_QHY5LII_C_OrionAllInOne      4095
#define DEVICETYPE_QHY5LII_M_Orion_StarShoot      4096

#define DEVICETYPE_QHY550_PM        4097
#define DEVICETYPE_QHY550_PC        4098
#define DEVICETYPE_QHY550_M        4099
#define DEVICETYPE_QHY550_C        4100

#define DEVICETYPE_QHY5III482C        4101
#define DEVICETYPE_QHY5III464         4102

#define DEVICETYPE_QHY183A              4105
#define DEVICETYPE_QHY183A_M            4106
#define DEVICETYPE_QHY183A_C            4107

#define DEVICETYPE_QHY5III334            4108
#define DEVICETYPE_QHY5III334M           4109
#define DEVICETYPE_QHY5III334C           4110

#define DEVICETYPE_QHY991                4111
#define DEVICETYPE_QHY1253               4112
#define DEVICETYPE_QHY5III415            4113

#define DEVICETYPE_QHY1920             4114
#define DEVICETYPE_QHY1920M            4115
#define DEVICETYPE_QHY1920C            4116

#define DEVICETYPE_QHY9701             4117
#define DEVICETYPE_QHY530              4118

#define DEVICETYPE_QHY600M_OEM     		4119
#define DEVICETYPE_QHY533M              4120
#define DEVICETYPE_QHY5III200M              4121
#define DEVICETYPE_QHY5III585C              4122
#define DEVICETYPE_QHY10768              4123
#define DEVICETYPE_QHY6060Pro              4124

#define DEVICETYPE_QHY5III678              4125
#define DEVICETYPE_QHY5III678C             4126
#define DEVICETYPE_QHY5III678M             4127

#define DEVICETYPE_QHY342PRO              4128

#define DEVICETYPE_QHY5III715              4129
#define DEVICETYPE_QHY5III715C             4130
#define DEVICETYPE_QHY5III715M             4131

#define DEVICETYPE_QHY630T                 4132

#define DEVICETYPE_QHY268_OEM              4133
#define DEVICETYPE_QHY268M_OEM             4134
#define DEVICETYPE_QHY268C_OEM             4135

#define DEVICETYPE_QHY5III568M             4136
#define DEVICETYPE_QHY5III568C             4137

#define DEVICETYPE_QHYMINICAM8M            4138
#define DEVICETYPE_QHYMINICAM8C            4139

#define DEVICETYPE_QHY533M_OEM             4140
#define DEVICETYPE_QHY533C_OEM             4141

#define DEVICETYPE_QHY487              4142
/**
 * Type define for QHY5IIIEND*/
#define DEVICETYPE_QHY5IIIEND   	4999

/**
 * Type define for QHY16 */
#define DEVICETYPE_QHY16        16

/**
 * Type define for QHY6 */
#define DEVICETYPE_QHY6         60

/**
 * Type define for QHY7 */
#define DEVICETYPE_QHY7         70

/**
 * Type define for QHY2PRO */
#define DEVICETYPE_QHY2PRO      221

/**
 * Type define for IMG2P */
#define DEVICETYPE_IMG2P        220

/**
 * Type define for QHY8 */
#define DEVICETYPE_QHY8         400

/**
 * Type define for QHY8PRO */
#define DEVICETYPE_QHY8PRO      453

/**
 * Type define for QHY16000 */
#define DEVICETYPE_QHY16000     361

/**
 * Type define for QHY12 */
#define DEVICETYPE_QHY12        613

/**
 * Type define for IC8300 */
#define DEVICETYPE_IC8300       890

/**
 * Type define for QHY9S */
#define DEVICETYPE_QHY9S        892

/**
 * Type define for QHY10 */
#define DEVICETYPE_QHY10        893

/**
 * Type define for QHY8L */
#define DEVICETYPE_QHY8L        891

/**
 * Type define for QHY11 */
#define DEVICETYPE_QHY11        894

/**
 * Type define for QHY21 */
#define DEVICETYPE_QHY21        895

/**
 * Type define for QHY22 */
#define DEVICETYPE_QHY22        896

/**
 * Type define for QHY23 */
#define DEVICETYPE_QHY23        897

/**
 * Type define for QHY15 */
#define DEVICETYPE_QHY15        898

/**
 * Type define for QHY27 */
#define DEVICETYPE_QHY27        899


/**
 * Type define for QHY28 */
#define DEVICETYPE_QHY28        902

/**
 * Type define for QHY9T */
#define DEVICETYPE_QHY9T        905

/**
 * Type define for QHY29 */
#define DEVICETYPE_QHY29        907

/**
 * Type define for SOLAR1600 */
#define DEVICETYPE_SOLAR1600    908

/* QHYA seires */

/**
 * Type define for QHY90A/IC90A */
#define DEVICETYPE_90A          900

/**
 * Type define for QHY16200A/IC16200A */
#define DEVICETYPE_16200A       901

/**
 * Type define for QHY814A/IC814A */
#define DEVICETYPE_814A         903

/**
 * Type define for 16803 */
#define DEVICETYPE_16803        906

/**
 * Type define for 16803 */
#define DEVICETYPE_09000        930


/**
 * Type define for 695A*/
#define DEVICETYPE_695A         916


/**
 * Type define for QHY15GIGAE */
#define DEVICETYPE_QHY15G       9000

/**
 * Type define for SOLAR800G */
#define DEVICETYPE_SOLAR800G    9001

#define DEVICETYPE_A0340G       9003

#define DEVICETYPE_QHY08050G    9004

#define DEVICETYPE_QHY694G      9005

#define DEVICETYPE_QHY27G       9006

#define DEVICETYPE_QHY23G       9007

#define DEVICETYPE_QHY16000G    9008

#define DEVICETYPE_QHY160002AD  9009

#define DEVICETYPE_QHY814G      9010

#define DEVICETYPE_QHY45GX      9011

#define DEVICETYPE_QHY10_FOCUS  9012

#define DEVICETYPE_QHY50GX      9013


/**
 * Type define for QHYPCIEBEGIN*/
#define DEVICETYPE_QHYPCIEBEGIN   		0X66180000

#define DEVICETYPE_QHY4040PROPCIE  		0X66184043
#define DEVICETYPE_QHY411ERISPCIE  		0X6618c414
#define DEVICETYPE_QHY600PCIE      		0X6618c603
#define DEVICETYPE_QHY268PCIE      		0X6618c269
#define DEVICETYPE_QHY530PCIE      		0X6618c531
#define DEVICETYPE_QHY6060P_PCIE      	0X66186063
#define DEVICETYPE_QHY990PCIE      		0X6618c991
#define DEVICETYPE_QHY991PCIE      		0X6618d992
#define DEVICETYPE_QHY461PCIE      		0X6618c462
#define DEVICETYPE_QHY342PCIE      		0X66180345
#define DEVICETYPE_QHY487PCIE			0X6618c488



#define DEVICETYPE_QHYPCIEEND	   		0X6618ffff


/* IMG series */
#define IMG132E_MAX_WIDTH        	1280
#define IMG132E_MAX_HEIGHT        	1024

/**
 * Type define for IMG0H */
#define IMG0H_MAX_WIDTH        		640
#define IMG0H_MAX_HEIGHT        	480

/**
 * Type define for IMG0L */
#define IMG0L_MAX_WIDTH        		-1
#define IMG0L_MAX_HEIGHT        	-1

/**
 * Type define for IMG0X */

#define IMG0X_MAX_WIDTH        		-1
#define IMG0X_MAX_HEIGHT        	-1

/**
 * Type define for IMG1S */
#define IMG1S_MAX_WIDTH        		-1
#define IMG1S_MAX_HEIGHT        	-1

/**
 * Type define for IMG2S */
#define IMG2S_MAX_WIDTH        		-1
#define IMG2S_MAX_HEIGHT        	-1

/**
 * Type define for IMG1E */
#define IMG1E_MAX_WIDTH        		-1
#define IMG1E_MAX_HEIGHT        	-1


/* QHY5 seires */

/**
 * Type define for QHY5 */
#define QHY5_MAX_WIDTH        	1280
#define QHY5_MAX_HEIGHT        	1024


/* QHY5II series */

/**
 * Type define for QHY5II */
#define QHY5II_MAX_WIDTH        	1280
#define QHY5II_MAX_HEIGHT        	1024

/**
 * Type define for QHY5LII_M */
#define QHY5LII_M_MAX_WIDTH        		1280
#define QHY5LII_M_MAX_HEIGHT        	960

/**
 * Type define for QHY5LII_C */
#define QHY5LII_C_MAX_WIDTH        		1280
#define QHY5LII_C_MAX_HEIGHT        	960

/**
 * Type define for QHY5TII */
#define QHY5TII_MAX_WIDTH        		-1
#define QHY5TII_MAX_HEIGHT        		-1

/**
 * Type define for QHY5RII */
#define QHY5RII_MAX_WIDTH        		-1
#define QHY5RII_MAX_HEIGHT        		-1

/**
 * Type define for QHY5PII */
#define QHY5PII_MAX_WIDTH        		-1
#define QHY5PII_MAX_HEIGHT        		-1

/**
 * Type define for QHY5VII */
#define QHY5VII_MAX_WIDTH        		-1
#define QHY5VII_MAX_HEIGHT        		-1

/**
 * Type define for QHY5HII */
#define QHY5HII_MAX_WIDTH        		1280
#define QHY5HII_MAX_HEIGHT        		960

/**
 * Type define for QHYXXX */
#define MINICAM5S_M_MAX_WIDTH        	1280
#define MINICAM5S_M_MAX_HEIGHT        	960

/**
 * Type define for QHYXXX */
#define MINICAM5S_C_MAX_WIDTH        	1280
#define MINICAM5S_C_MAX_HEIGHT        	960

/**
 * Type define for QHY5PII_C */
#define QHY5PII_C_MAX_WIDTH        		2592
#define QHY5PII_C_MAX_HEIGHT        	1944

/**
 * Type define for QHY5RII-M */
#define QHY5RII_C_MAX_WIDTH        		728
#define QHY5RII_C_MAX_HEIGHT        	512

/**
 * Type define for QHY5RII-M */
#define MINICAM5F_M_MAX_WIDTH        	1280
#define MINICAM5F_M_MAX_HEIGHT        	960

/**
 * Type define for QHY5PII_M */
#define QHY5PII_M_MAX_WIDTH        		2592
#define QHY5PII_M_MAX_HEIGHT        	1944

/**
 * Type define for QHY5TII */
#define QHY5TII_C_MAX_WIDTH        		2048
#define QHY5TII_C_MAX_HEIGHT        	1536

/**
 * Type define for POLEMASTER */
#define POLEMASTER_MAX_WIDTH        	1280
#define POLEMASTER_MAX_HEIGHT        	960


/* QHY5III seires */

/**
 * Type define for QHY5III174 */
#define QHY5III174_MAX_WIDTH        	1920
#define QHY5III174_MAX_HEIGHT        	1200


/**
 * Type define for QHY5III174 */
#define QHY5III174M_MAX_WIDTH        	QHY5III174_MAX_WIDTH
#define QHY5III174M_MAX_HEIGHT        	QHY5III174_MAX_HEIGHT

/**
 * Type define for QHY5III174C*/
#define QHY5III174C_MAX_WIDTH        	QHY5III174_MAX_WIDTH
#define QHY5III174C_MAX_HEIGHT        	QHY5III174_MAX_HEIGHT

/**
 * Type define for QHY174*/
#define QHY174_MAX_WIDTH        	1920
#define QHY174_MAX_HEIGHT        	1200

/**
 * Type define for QHY174M*/
#define QHY174M_MAX_WIDTH        	QHY174_MAX_WIDTH
#define QHY174M_MAX_HEIGHT        	QHY174_MAX_HEIGHT

/**
 * Type define for QHY174C*/
#define QHY174C_MAX_WIDTH        	QHY174_MAX_WIDTH
#define QHY174C_MAX_HEIGHT        	QHY174_MAX_HEIGHT



/**
 * Type define for QHY5III174*/
#define QHY5III174BASE_MAX_WIDTH    QHY5III174_MAX_WIDTH
#define QHY5III174BASE_MAX_HEIGHT   QHY5III174_MAX_HEIGHT




/**
 * Type define for QHY5III178*/
#define QHY5III178_MAX_WIDTH        	3056
#define QHY5III178_MAX_HEIGHT        	2048

/**
 * Type define for QHY5III178C*/
#define QHY5III178C_MAX_WIDTH        	QHY5III178_MAX_WIDTH
#define QHY5III178C_MAX_HEIGHT        	QHY5III178_MAX_HEIGHT

/**
 * Type define for QHY5III178M*/
#define QHY5III178M_MAX_WIDTH        	QHY5III178_MAX_WIDTH
#define QHY5III178M_MAX_HEIGHT        	QHY5III178_MAX_HEIGHT

/**
 * Type define for QHY5III178*/
#define QHY5III178BASE_MAX_WIDTH        	QHY5III178_MAX_WIDTH
#define QHY5III178BASE_MAX_HEIGHT        	QHY5III178_MAX_HEIGHT


/**
 * Type define for QHY178*/
#define QHY178_MAX_WIDTH        	3056
#define QHY178_MAX_HEIGHT        	2048

/**
 * Type define for QHY178M*/
#define QHY178M_MAX_WIDTH        	QHY178_MAX_WIDTH
#define QHY178M_MAX_HEIGHT        	QHY178_MAX_HEIGHT

/**
 * Type define for QHY178C*/
#define QHY178C_MAX_WIDTH        	QHY178_MAX_WIDTH
#define QHY178C_MAX_HEIGHT        	QHY178_MAX_HEIGHT

/**
 * Type define for QHY5III178*/
#define QHY5III178COOLBASE_MAX_WIDTH        	QHY178_MAX_WIDTH
#define QHY5III178COOLBASE_MAX_HEIGHT        	QHY178_MAX_HEIGHT


/**
 * Type define for QHY5III185*/
#define QHY5III185_MAX_WIDTH        	1920
#define QHY5III185_MAX_HEIGHT        	1200

/**
 * Type define for QHY5III185C*/
#define QHY5III185C_MAX_WIDTH        	QHY5III185_MAX_WIDTH
#define QHY5III185C_MAX_HEIGHT        	QHY5III185_MAX_HEIGHT

/**
 * Type define for QHY5III185M*/
#define QHY5III185M_MAX_WIDTH        	QHY5III185_MAX_WIDTH
#define QHY5III185M_MAX_HEIGHT        	QHY5III185_MAX_HEIGHT


/**
 * Type define for QHY5III185M*/
#define QHY5III185BASE_MAX_WIDTH        QHY5III185_MAX_WIDTH
#define QHY5III185BASE_MAX_HEIGHT       QHY5III185_MAX_HEIGHT


/**
 * Type define for QHY185*/
#define QHY185_MAX_WIDTH        	-1
#define QHY185_MAX_HEIGHT        	-1

/**
 * Type define for QHY185M*/
#define QHY185M_MAX_WIDTH        	-1
#define QHY185M_MAX_HEIGHT        	-1

/**
 * Type define for QHY185C*/
#define QHY185C_MAX_WIDTH        	-1
#define QHY185C_MAX_HEIGHT        	-1

/**
 * Type define for QHY5III224*/
#define QHY5III224_MAX_WIDTH        	1280
#define QHY5III224_MAX_HEIGHT        	960

/**
 * Type define for QHY5III224C*/
#define QHY5III224C_MAX_WIDTH        	QHY5III224_MAX_WIDTH
#define QHY5III224C_MAX_HEIGHT        	QHY5III224_MAX_HEIGHT

/**
 * Type define for QHY5III224M*/
#define QHY5III224M_MAX_WIDTH        	QHY5III224_MAX_WIDTH
#define QHY5III224M_MAX_HEIGHT        	QHY5III224_MAX_HEIGHT

/**
 * Type define for QHY5III224M*/
#define QHY5III224BASE_MAX_WIDTH        	QHY5III224_MAX_WIDTH
#define QHY5III224BASE_MAX_HEIGHT        	QHY5III224_MAX_HEIGHT

/**
 * Type define for QHY224*/
#define QHY224_MAX_WIDTH        	1280
#define QHY224_MAX_HEIGHT        	960

/**
 * Type define for QHY224M*/
#define QHY224M_MAX_WIDTH        	QHY224_MAX_WIDTH
#define QHY224M_MAX_HEIGHT        	QHY224_MAX_HEIGHT

/**
 * Type define for QHY224C*/
#define QHY224C_MAX_WIDTH        	QHY224_MAX_WIDTH
#define QHY224C_MAX_HEIGHT        	QHY224_MAX_HEIGHT

/**
 * Type define for QHY224C*/
#define QHY5III224COOLBASE_MAX_WIDTH        	QHY224_MAX_WIDTH
#define QHY5III224COOLBASE_MAX_HEIGHT        	QHY224_MAX_HEIGHT

/**
 * Type define for QHY5III290*/
#define QHY5III290_MAX_WIDTH        	1920
#define QHY5III290_MAX_HEIGHT        	1080

/**
 * Type define for QHY5III290C*/
#define QHY5III290C_MAX_WIDTH        	QHY5III290_MAX_WIDTH
#define QHY5III290C_MAX_HEIGHT        	QHY5III290_MAX_HEIGHT

/**
 * Type define for QHY5III290M*/
#define QHY5III290M_MAX_WIDTH        	QHY5III290_MAX_WIDTH
#define QHY5III290M_MAX_HEIGHT        	QHY5III290_MAX_HEIGHT

/**
 * Type define for QHY5III290M*/
#define QHY5III290BASE_MAX_WIDTH        	QHY5III290_MAX_WIDTH
#define QHY5III290BASE_MAX_HEIGHT        	QHY5III290_MAX_HEIGHT

/**
 * Type define for QHY5III290*/
#define QHY290_MAX_WIDTH        	1920
#define QHY290_MAX_HEIGHT        	1080



/**
 * Type define for QHY290M*/
#define QHY290M_MAX_WIDTH        	QHY290_MAX_WIDTH
#define QHY290M_MAX_HEIGHT        	QHY290_MAX_HEIGHT

/**
 * Type define for QHY290C*/
#define QHY290C_MAX_WIDTH        	QHY290_MAX_WIDTH
#define QHY290C_MAX_HEIGHT        	QHY290_MAX_HEIGHT

/**
 * Type define for QHY290C*/
#define QHY5III290COOLBASE_MAX_WIDTH        	QHY290_MAX_WIDTH
#define QHY5III290COOLBASE_MAX_HEIGHT        	QHY290_MAX_HEIGHT

/**
 * Type define for QHY5III236*/
#define QHY5III236_MAX_WIDTH        	1952
#define QHY5III236_MAX_HEIGHT        	1237

/**
 * Type define for QHY5III236C*/
#define QHY5III236C_MAX_WIDTH        	QHY5III236_MAX_WIDTH
#define QHY5III236C_MAX_HEIGHT        	QHY5III236_MAX_HEIGHT

/**
 * Type define for QHY5III290M*/
#define QHY5III236M_MAX_WIDTH        	QHY5III236_MAX_WIDTH
#define QHY5III236M_MAX_HEIGHT        	QHY5III236_MAX_HEIGHT

/**
 * Type define for QHY236*/
#define QHY236_MAX_WIDTH        	-1
#define QHY236_MAX_HEIGHT        	-1

/**
 * Type define for QHY236M*/
#define QHY236M_MAX_WIDTH        	QHY236_MAX_WIDTH
#define QHY236M_MAX_HEIGHT        	QHY236_MAX_HEIGHT

/**
 * Type define for QHY236C*/
#define QHY236C_MAX_WIDTH        	QHY236_MAX_WIDTH
#define QHY236C_MAX_HEIGHT        	QHY236_MAX_HEIGHT

/**
 * Type define for GSENSE400*/
#define QHY5IIIG400M_MAX_WIDTH        	2048
#define QHY5IIIG400M_MAX_HEIGHT        	2048

/**
 * Type define for QHY163*/
#define QHY163_MAX_WIDTH        	4656
#define QHY163_MAX_HEIGHT        	3522

/**
 * Type define for QHY163M*/
#define QHY163M_MAX_WIDTH        	QHY163_MAX_WIDTH
#define QHY163M_MAX_HEIGHT        	QHY163_MAX_HEIGHT

/**
 * Type define for QHY163C*/
#define QHY163C_MAX_WIDTH        	QHY163_MAX_WIDTH
#define QHY163C_MAX_HEIGHT        	QHY163_MAX_HEIGHT

/**
 * Type define for QHY165*/
#define QHY165_MAX_WIDTH        	4936
#define QHY165_MAX_HEIGHT        	3286

/**
 * Type define for QHY165C*/
#define QHY165C_MAX_WIDTH        	QHY165_MAX_WIDTH
#define QHY165C_MAX_HEIGHT        	QHY165_MAX_HEIGHT

/**
 * Type define for QHY367*/
#define QHY367_MAX_WIDTH        	7380
#define QHY367_MAX_HEIGHT        	4908

/**
 * Type define for QHY367C*/
#define QHY367C_MAX_WIDTH        	QHY367_MAX_WIDTH
#define QHY367C_MAX_HEIGHT        	QHY367_MAX_HEIGHT

/**
 * Type define for QHY183*/
#define QHY183_MAX_WIDTH        	5544
#define QHY183_MAX_HEIGHT        	3684

/**
 * Type define for QHY183C*/
#define QHY183C_MAX_WIDTH        	QHY183_MAX_WIDTH
#define QHY183C_MAX_HEIGHT        	QHY183_MAX_HEIGHT

/**
 * Type define for QHY-DevelopDev*/
#define QHY5IIICOMMON_MAX_WIDTH      14304//6280//5336//4144//3864//5680//2712//3864// 2712// 1408    //8432  	
#define QHY5IIICOMMON_MAX_HEIGHT     10748//4210//4908//3064//2192//3710//1538//2180// 1538// 1052    //5648	  

/**
 * Type define for QHY247*/
#define QHY247_MAX_WIDTH        	6088
#define QHY247_MAX_HEIGHT        	4052

/**
 * Type define for QHY247C*/
#define QHY247C_MAX_WIDTH        	QHY247_MAX_WIDTH
#define QHY247C_MAX_HEIGHT        	QHY247_MAX_HEIGHT

/**
 * Type define for QHY247C*/
#define QHY5III247BASE_MAX_WIDTH        	QHY247_MAX_WIDTH
#define QHY5III247BASE_MAX_HEIGHT        	QHY247_MAX_HEIGHT


/**
 * Type define for MINICAM6F*/
#define MINICAM6F_MAX_WIDTH        QHY5III178COOLBASE_MAX_WIDTH
#define MINICAM6F_MAX_HEIGHT       QHY5III178COOLBASE_MAX_HEIGHT

/**
 * Type define for QHY168C*/
#define QHY168_MAX_WIDTH        	5056
#define QHY168_MAX_HEIGHT        	3358

#define QHY168C_MAX_WIDTH        	QHY168_MAX_WIDTH
#define QHY168C_MAX_HEIGHT        	QHY168_MAX_HEIGHT

#define QHY5III168BASE_MAX_WIDTH        	QHY168_MAX_WIDTH
#define QHY5III168BASE_MAX_HEIGHT        	QHY168_MAX_HEIGHT

/**
 * Type define for QHY128C*/
#define QHY128_MAX_WIDTH        	6036
#define QHY128_MAX_HEIGHT        	4036

#define QHY128C_MAX_WIDTH        	QHY128_MAX_WIDTH
#define QHY128C_MAX_HEIGHT        	QHY128_MAX_HEIGHT

#define QHY294_MAX_WIDTH        	4212
#define QHY294_MAX_HEIGHT        	2850
// FixME fix  number
#define QHY294_M_C_PRO_MAX_WIDTH_Mod_14_11M        4212
#define QHY294_M_C_PRO_MAX_HEIGHT_Mod_14_11M       2850
#define QHY294_M_C_PRO_MAX_WIDTH_Mod_12_47M        8432
#define QHY294_M_C_PRO_MAX_HEIGHT_Mod_12_47M       5648

#define QHY492_MAX_WIDTH        	4212
#define QHY492_MAX_HEIGHT        	2850

#define QHY2020_MAX_WIDTH        	4096
#define QHY2020_MAX_HEIGHT        	2048

#define QHY4040_MAX_WIDTH        	4096
#define QHY4040_MAX_HEIGHT        	4118

#define QHY4040PRO_MAX_WIDTH        	4096
#define QHY4040PRO_MAX_HEIGHT        	4118


#define QHY550_MAX_WIDTH        	2496
#define QHY550_MAX_HEIGHT        	2080

#define QHY990_MAX_WIDTH        	1408
#define QHY990_MAX_HEIGHT        	1052

#define QHY991_MAX_WIDTH        	768
#define QHY991_MAX_HEIGHT        	540

#define QHY42PRO_MAX_WIDTH        	4096
#define QHY42PRO_MAX_HEIGHT        	2048

#define QHY6060_MAX_WIDTH        	7936
#define QHY6060_MAX_HEIGHT        	6134

#define QHY10768_MAX_WIDTH        	1028
#define QHY10768_MAX_HEIGHT        	50

#define QHY411_MAX_WIDTH        	14304
#define QHY411_MAX_HEIGHT        	10748

// 10802-92-54=10656 max_y-topBlank-bottomBlank=imageHeight
// 14304-48-48=14208 max_x-leftBlank-rightBlank=imageWidth
// only y-shift is supported by most sensor
#define QHY411ERIS_MAX_WIDTH        14304
// the target image is  W 14304 H 10748, top blank cut by soft roi, so, have to add 38 to bottom
#define QHY411ERIS_MAX_HEIGHT       (10802 + 38)
// can not use isOverscanRemoved=false to get a black border image in sharpCap,because sharpCap use effective size to set whole image size, not like ezcap or ascom driver
#define QHY411ERIS_Left_Blank_single       48
#define QHY411ERIS_right_Blank_single      48
#define QHY411ERIS_Left_Blank_live       0
#define QHY411ERIS_right_Blank_live      0
#define QHY411ERIS_Top_Blank        92
//81 is a default shift value, set to 81 can save data size
#define QHY411ERIS_M_Default_SHIFT  81
// for color sensor, shift value must be an odd number
#define QHY411ERIS_C_Default_SHIFT  81
// bottom can be set to 0 to reduce data size (set bottom to 0 and set max_height to 10748 (but now we need overScan area and fit to W 14304 H 10748 , so, can not set to 0)
//#define QHY411ERIS_Bottom_Blank     (54 + 38)
#define QHY411ERIS_Bottom_Blank_live     (0 + 0)
#define QHY411ERIS_Bottom_Blank_single     (54 + 38)


#define QHY411ERIS_BIN33_MAX_WIDTH        4768
#define QHY411ERIS_BIN33_MAX_HEIGHT       3588
#define QHY411ERIS_M_BIN33_Left_Blank       16
#define QHY411ERIS_M_BIN33_right_Blank      16
#define QHY411ERIS_BIN33_Top_Blank        34

#define QHY411ERIS_BIN33_M_C_Default_SHIFT  27
//for onchip 3*3binning. in camera firmware it is input * 3 . it can be both odd or even
#define QHY411ERIS_BIN33_M_Default_SHIFT  28
// for color sensor, shift value must be an odd number
#define QHY411ERIS_BIN33_C_Default_SHIFT  85
// bottom can be set to 0 to reduce data size (set bottom to 0 and set max_height to 10748
#define QHY411ERIS_BIN33_Bottom_Blank     6



#define QHY600_MAX_WIDTH        	9600
#define QHY600_MAX_HEIGHT        	6422


#define QHY461_MAX_WIDTH		   11760
#define QHY461_MAX_HEIGHT		   8842

#define QHY268C_MAX_WIDTH        6288
#define QHY268C_MAX_HEIGHT       4210

//#define QHY410C_MAX_WIDTH        6112
//#define QHY410C_MAX_HEIGHT       4140-100

#define QHY432_MAX_WIDTH        1624
#define QHY432_MAX_HEIGHT       1136

#define QHY342_MAX_WIDTH        6512
#define QHY342_MAX_HEIGHT       4870
/**
 * Type define for QHY16 */
#define QHY16_MAX_WIDTH        	4144
#define QHY16_MAX_HEIGHT        4128

/**
 * Type define for QHY6 */
#define QHY6_MAX_WIDTH        	800
#define QHY6_MAX_HEIGHT        	596

/**
 * Type define for QHY7 */
#define QHY7_MAX_WIDTH        	2112
#define QHY7_MAX_HEIGHT        	2072

/**
 * Type define for QHY2PRO */
#define QHY2PRO_MAX_WIDTH        	1440
#define QHY2PRO_MAX_HEIGHT        	1050

/**
 * Type define for IMG2P */
#define IMG2P_MAX_WIDTH        		1436
#define IMG2P_MAX_HEIGHT        	1050

/**
 * Type define for QHY8 */
#define QHY8_MAX_WIDTH        	3328
#define QHY8_MAX_HEIGHT        	2030

/**
 * Type define for QHY8PRO */
#define QHY8PRO_MAX_WIDTH        	3328
#define QHY8PRO_MAX_HEIGHT        	2030

/**
 * Type define for QHY16000 */
#define QHY16000_MAX_WIDTH        	4960
#define QHY16000_MAX_HEIGHT        	3328

/**
 * Type define for QHY12 */
#define QHY12_MAX_WIDTH        	3328
#define QHY12_MAX_HEIGHT        4640

/**
 * Type define for IC8300 */
#define IC8300_MAX_WIDTH        	3584
#define IC8300_MAX_HEIGHT        	2576

/**
 * Type define for QHY9S */
#define QHY9S_MAX_WIDTH        	3584
#define QHY9S_MAX_HEIGHT        2574

/**
 * Type define for QHY10 */
#define QHY10_MAX_WIDTH        	2816
#define QHY10_MAX_HEIGHT        3940


/**
 * Type define for QHY8L */
#define QHY8L_MAX_WIDTH        	3328
#define QHY8L_MAX_HEIGHT        2030

/**
 * Type define for QHY11 */
#define QHY11_MAX_WIDTH        	4096
#define QHY11_MAX_HEIGHT        2720

/**
 * Type define for QHY21 */
#define QHY21_MAX_WIDTH        	2048
#define QHY21_MAX_HEIGHT        1500



/**
 * Type define for QHY23 */
#define QHY23_MAX_WIDTH        	3584
#define QHY23_MAX_HEIGHT        2728

/**
 * Type define for QHY15 */
#define QHY15_MAX_WIDTH        	3108
#define QHY15_MAX_HEIGHT        3086

/**
 * Type define for QHY27 */
#define QHY27_MAX_WIDTH        	5120
#define QHY27_MAX_HEIGHT        3332


/**
 * Type define for QHY28 */
#define QHY28_MAX_WIDTH        	5120
#define QHY28_MAX_HEIGHT        3332

/**
 * Type define for QHY9T */
#define QHY9T_MAX_WIDTH        	3584
#define QHY9T_MAX_HEIGHT        2574

/**
 * Type define for QHY29 */
#define QHY29_MAX_WIDTH        	6656
#define QHY29_MAX_HEIGHT        4452

/**
 * Type define for SOLAR1600 */
#define SOLAR1600_MAX_WIDTH        	4928
#define SOLAR1600_MAX_HEIGHT        3264

/* QHYA seires */

/**
 * Type define for QHY90A/IC90A */
#define QHY90A_MAX_WIDTH        	3584
#define QHY90A_MAX_HEIGHT        	2576

/**
 * Type define for QHY16200A/IC16200A */
#define QHY16200A_MAX_WIDTH        	5120
#define QHY16200A_MAX_HEIGHT        3696

/**
 * Type define for QHY814A/IC814A */
#define QHY814A_MAX_WIDTH        	3584
#define QHY814A_MAX_HEIGHT        	2720

/**
 * Type define for 16803 */
#define IC16803_MAX_WIDTH        	4192
#define IC16803_MAX_HEIGHT        	4128

/**
 * Type define for 16803 */
#define QHY09000_MAX_WIDTH        	3140
#define QHY09000_MAX_HEIGHT        	3096


/**
 * Type define for 695A*/
#define QHY695A_MAX_WIDTH        	3072
#define QHY695A_MAX_HEIGHT        	2240


/**
 * Type define for QHY15GIGAE */
#define QHY15G_MAX_WIDTH        	-1
#define QHY15G_MAX_HEIGHT        	-1

/**
 * Type define for SOLAR800G */
#define SOLAR800G_MAX_WIDTH        	3584
#define SOLAR800G_MAX_HEIGHT        2574

#define A0340G_MAX_WIDTH        	-1
#define A0340G_MAX_HEIGHT        	-1

#define QHY08050G_MAX_WIDTH        	(3392 - 14)
#define QHY08050G_MAX_HEIGHT         2560

#define QHY694G_MAX_WIDTH        	-1
#define QHY694G_MAX_HEIGHT        	-1

#define QHY27G_MAX_WIDTH        	-1
#define QHY27G_MAX_HEIGHT        	-1

#define QHY23G_MAX_WIDTH        	-1
#define QHY23G_MAX_HEIGHT        	-1

#define QHY16000G_MAX_WIDTH        		4960
#define QHY16000G_MAX_HEIGHT        	3328

#define QHY160002AD_MAX_WIDTH        	5120
#define QHY160002AD_MAX_HEIGHT        	3328

#define QHY814G_MAX_WIDTH        	3584
#define QHY814G_MAX_HEIGHT        	2728

#define QHY45GX_MAX_WIDTH        	1280
#define QHY45GX_MAX_HEIGHT        	1024



#define QHY50GX_MAX_WIDTH        	8400
#define QHY50GX_MAX_HEIGHT        	6220



/**
 * Type define for UNKNOW */
#define DEVICETYPE_UNKNOW       -1

#define MAX_EXPOSURE_TIMES	(3600) //s

#define REMAINING_MIN_EXPOSURETIMES	(3000)//ms

#define		MAX_CAMERA_NUMBER		200
#define		CAMERA_ID_LENGTH		64   //(CAMERA_ID_LENGTH and ID_STR_LEN) more like a full ID length: QHY178-xxxxx(Mode included)
#define   	MAXDEVICES 				15


#define		MAX_READMODE_NAME			256
#define		MAX_READMODE_CAM_NUMBER		6


#define	SEND_CAMERA_NO_MESSAGE						0


#define	SEND_CAMERA_ID								9501
#define	SEND_CAMERA_STATUS							9502
#define	SEND_CAMERA_LIVE							9503
#define	SEND_CAMERA_SINGLE							9504
#define	SEND_CAMERA_CAPABLE							9505
#define	SEND_CAMERA_MAXMINSTEP						9506
#define	SEND_CAMERA_EXPOSING						9507

#define	CAMERA_HANDLE_INVALID						9508
#define	HANDLE_IS_NULL								9509
#define	USB_PORT_ERROR								9510




#define	CAMERA_LOSE									10001
#define	CAMERA_INSERT								10002

#define	CAMERA_LIVE_ERROR							10003
#define	CAMERA_LIVE_DATA_AVAILABLE					10004
#define	CAMERA_LIVE_STOP							10005
#define	CAMERA_LIVE_TIMEOUT							10006

#define	CAMERA_SINGLE_ERROR							10011
#define	CAMERA_SINGLE_DATA_AVAILABLE				10012
#define	CAMERA_SINGLE_STOP							10013
#define	CAMERA_SINGLE_TIMEOUT						10014

#define	SEND_MSG_NONE				0
#define	SEND_MSG_WHOLE				1
#define	SEND_MSG_PART				2


#define   SINGLE_MODE 								0
#define   LIVE_MODE 								1

#define   QHYCCDParam_On            1
#define   QHYCCDParam_Off           0
#define   QHYCCDParam_AirPump_On           3
#define   QHYCCDParam_AirPump_Off          4

#define   FLASH_CONFIG_PAGE_INDEX					1

#define   FPGA_MODE_DEFAULT 						99
#define   FPGA_MODE_12_47M 								12     //14bit rigister= 11M  12bit rigister = 47M
#define   FPGA_MODE_14_11M 								14         //14bit rigister= 11M  12bit rigister = 47M

#define   GET_IMAGE_TIMEOUT							60000     //QHY09000 DRIFT SCAN MOD  600000  
//#define   GET_IMAGE_TIMEOUT							900000     //QHY09000 DRIFT SCAN MOD  600000  

#define   IS_OPERATOR_NONE						0
#define   IS_CAMARA_INIT				1
#define   IS_CAMARA_OPEN				2
#define   IS_CAMARA_CLOSE				3
#define   IS_CAMARA_STOP_LIVE			4
#define   IS_CAMARA_CAN_EXP				5
#define   IS_CAMARA_ERROR				6
#define   IS_GET_SINGLEPICTURE			7
#define   IS_GET_LIVEPICTURE			8



#define	COMMAND_QUEUE_PUSH		1
#define	COMMAND_QUEUE_POP		2




#define	DEMO_MAXDEVICES				6
#define	MESSAGE_SIZS				1000


#define CFWSLOTS_NUM9		9
#define CFWSLOTS_NUM8		8
#define CFWSLOTS_NUM7		7
#define CFWSLOTS_NUM6		6

#define CFWSLOTS_DELAY		4000

#define RESET_USB_PIPE		1
#define ABORT_USB_PIPE		2



#define MAX_PCIE_CHANNEL		4

#define	FPGA_CAMARA_LENGTH		256

#define	CAM_SCAN_INTERVAL 		1000

#define CRC32_POLY  			(0x04C11DB7)



#define	PCIE_CARD_HEAD			(0x55EEAACC)

#define	PCIE_CARD_READ_C		(0x00005555)
#define	PCIE_CARD_WRITE_C		(0x00003333)

#define	PCIE_COMMAND_HEAD		(0xAAEE3322)

#define	PCIE_FPGA_WRITE_C		(0x00008881)
#define	PCIE_NIOS_READ_C		(0x00007770)
#define	PCIE_NIOS_WRITE_C		(0x00007771)

#define	PCIE_CAPTURE_WRITE_C	(0x66666665)


#define	PCIE_DWORD				(4)

//TODO try to find out what this stand for
#define	FRAME_BUFF_NUM	3

#define IS_WRITE  1
#define IS_READ	  2

#define CAM_CONN_STATUS_TO_NOTHING    1
#define CAM_CONN_STATUS_TO_PC         2
#define CAM_CONN_STATUS_TO_SDK        3

#endif
